/* nmdb/generic
 * -> Dynamic Date Entry v0.2 (js/nmdb_date-0.2.js)
 * Nathan Malinoski
 * natmal.net/code/
 * 2009-01-04
 */

/*
 * Changelog
 */
// 2009-01-04: * Code Cleanup
//             + Fixed: Day 29 not added when month is Feb. and switching from non-leap year to leap year.
//             + Fixed: Example HTML form now directs to itself instead of the fictional 'index.html'

// 2008-08-03: + Initial Release


/*
 * Settings
 */

// These define the current date in various forms for multiple purposes.
// Do not modify these.
var curDate=new Date();
var curYear=curDate.getFullYear();
var curMonth=curDate.getMonth()+1;
var curDay=curDate.getDate()+1;

// Defines the minimum year to display in the Year drop-down. Keep in mind
// this script is based on the Gregorian calendar, and any date prior to
// 1582-10-15 will be inaccurate.
// Default: 1900
var minYear=1900;

// Defines the maximum year to display in the Year drop-down. The default
// value automatically pulls the current date.
// Default: curYear
var maxYear=curYear;

// Defines whether we want to define the maximum date as the current date, or
// if we can allow any date. Setting this to true will force the maximum date
// selectable to be the current date and ignore the maxYear setting. Setting
// this to false will allow any month/date to be selected and the script will
// rely on the maxYear variable for an upper year limit.
// Default: false
var limitDateCurrent=false;
var limitDateCurrent=true;

// Defines whether we want to list the years in descending order (maxYear to
// minYear) or in ascending order (minYear to maxYear)
// Default: true
var sortDesc=true;


function isLeapYear(year){
  if(year%400==0)
    return true;
  if(year%100==0)
    return false;
  if(year%4==0)
    return true;
  return false;
}

function daysInMonth(month,year){
  if(month==2){
    if(isLeapYear(year))
      return 29;
    return 28;
  }
  if(month==4 || month==6 || month==9 || month==11)
    return 30;
  return 31;
}

function init_field(field){
  field.options.length=0;
  field.options[0]=new Option("","");
}

function populate(form_name,field,limit){
// Populate Year field
  if(field=="year"){
    var yearIndex=1;
    init_field(form_name.year);
    if(sortDesc==true){
      for(i=maxYear;i>=minYear;i--){
        form_name.year.options[yearIndex]=new Option(i,i);
        yearIndex++;
      }
    }
    else{
      for(i=minYear;i<=maxYear;i++){
        form_name.year.options[yearIndex]=new Option(i,i);
        yearIndex++;
      }
    }
  }

//Populate Month field, disable if needed
  else if(field=="month"){
    init_field(form_name.month);
    for(i=1;i<=limit;i++)
      form_name.month.options[i]=new Option(i,i);
  }

//Populate Day field, disabled if needed
  else if(field=="day"){
    init_field(form_name.day);
    for(i=1;i<=limit;i++)
      form_name.day.options[i]=new Option(i,i);
  }
}

function alter_field(obj,target){
  if(obj.length-1>target){
    var index=obj.options.selectedIndex;
    obj.options.length=target+1;
    if(index>target)
      obj.options.selectedIndex=target;
  }
  else if(obj.length-1<target){
    for(i=obj.length;i<=target;i++)
      obj.options[i]=new Option(i,i);
  }
}

function update_fields(obj){
  parent_form=document.getElementById(obj.form.id);

  if(obj.name=="year"){
//    if(parent_form.month.value!=0)
      alter_field(parent_form.day,daysInMonth(parent_form.month.value,obj.value));
  }
  else if(obj.name=="month"){
    alter_field(parent_form.day,daysInMonth(obj.value,parent_form.year.value));
  }
  else if(obj.name=="day"){
  }
}


/*
 * Init Sequence
 */
var form_name=document.getElementById("date_entry");
populate(form_name,"year",0);
populate(form_name,"month",12);
populate(form_name,"day",31);
